# Vitrea AV CVE-2021-44832 Script Setup

Version fbff2fa.

This folder contains formal details for running the Vitrea AV CVE-2021-44228 and CVE-2021-44832 fix:

* Make sure that 7za.exe is located in the same folder as the 'config-cve-2021-44832_fbff2fa.bat' file.


# Things to note before running the script

* This script must be run as a user with administrative privileges.
* To capture the output of the script for your record, run it as follows.
  * `config-cve-2021-44832_fbff2fa.bat >config.log 2>&1`
* The script will pause to prompt the user to check certain conditions during the script.  You can skip these pauses 
  by running it with the argument `/nopause`, for example to automate running the script.  In that case, it is strongly 
  recommended to capture the output of the script to a log file. 
* This script is for use on Vitrea AV 7.15.1 versions and before.
* This script is for all types of deployment of Vitrea AV.
  * If running on an Vitrea Enterprise system then please make sure that the Application nodes' VSP Application 
    Services are STOPPED, then run this script on the Management node and finally running this script on all 
    Application nodes and PowerStations.
* Please make sure that any active workflows have been finished as this script needs VSP Management and VSP 
  Application to be stopped.
* For testing purposes only, the mitigation can be checked by examining the `log4j-core-*.jar` files as follows.
  * The JAR files to check are as follow.
    * `%ProgramFiles%\Vital Images\Management\webapps\management\WEB-INF\lib\log4j-core-*.jar`
    * `%ProgramFiles%\Vital Images\Application\webapps\application\WEB-INF\lib\log4j-core-*.jar`
    * `%ProgramFiles%\Vital Images\Data\webapps\data\WEB-INF\lib\log4j-core-*.jar`
    * `%ProgramFiles%\Vital Images\Data\MintMetadataProcessor\lib\log4j-core-*.jar`
    * `%ProgramFiles%\Vital Images\Part19ToPart10Converter\lib\log4j-core-*.jar`
    * `%ProgramFiles%\Vital Images\DatabaseDeploymentTool\lib\log4j-core-*.jar`
  * In each JAR file, the following files should be _absent_.
    * `org/apache/logging/log4j/core/lookup/JndiLookup.class`
    * `org/apache/logging/log4j/core/net/JndiManager.class`
    * `org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class`


# 7-zip

7-zip is used as part of the CVE-2021-44228 and CVE-2021-44832 log4j fixes.

7za.exe is distributed under the GNU LGPL license.

Note: You can use 7-Zip on any computer, including a computer in a commercial 
organization. You don't need to register or pay for 7-Zip.

The source for 7-zip can be found at: www.7-zip.org.


## GNU LGPL information

The following licence applies to 7-zip.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You can receive a copy of the GNU Lesser General Public License from
    http://www.gnu.org/
