@ECHO OFF

setlocal EnableDelayedExpansion

if x%1x == x/nopausex (
  set WAIT=echo.
) else (
  set WAIT=pause
)

echo INFO: Running configuration script to mitigate the log4j vulnerabilities CVE-2021-44228, CVE-2021-45046, and CVE-2021-44832.
echo INFO: Version fbff2fa

reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Vital Images\Bootstrapper\Vitrea\Versions\RTM" /v Version > nul 2>&1
if errorlevel 1 (
    echo ERROR: Can't find Vitrea version information in HKEY_LOCAL_MACHINE\SOFTWARE\Vital Images\Bootstrapper\Vitrea\Versions\RTM.
    goto :exitFailure
)

for /f "tokens=2* skip=2" %%a in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Vital Images\Bootstrapper\Vitrea\Versions\RTM" /v "Version"') do (
    for /f "tokens=1,2,3 delims=." %%I in ("%%b") do (
        if %%I GTR 7 (
            echo ERROR: Script should not be run for versions 7.15.2 or later. Installed version is %%b.
            goto :exitFailure
        )
        if %%I EQU 7 (
            if %%J GTR 15 (
                echo ERROR: Script should not be run for versions 7.15.2 or later. Installed version is %%b.
                goto :exitFailure
            )
            if %%J EQU 14 (
                if %%K GEQ 5 (
                    echo ERROR: Script should not be run for versions 7.14.5 or later. Installed version is %%b.
                    goto :exitFailure
                )
            )
            if %%J EQU 15 (
                if %%K GEQ 2 (
                    echo ERROR: Script should not be run for versions 7.15.2 or later. Installed version is %%b.
                    goto :exitFailure
                )
            )
        )
    )
)

rem Check for admin rights; see https://stackoverflow.com/a/24270170/320456.
openfiles >nul 2>&1
if errorlevel 1 (
    echo ERROR: This script must be run as a user with administrative rights.
    goto :exitFailure
)

if not exist "%~dp0\7za.exe" (
    echo ERROR: 7za.exe must be present in the same folder as this script.
    goto :exitFailure
)

echo INFO: Checking if VSP service stop is required.

REM We check for the unwanted class files one at a time here because otherwise we might find "1 files" or "2 files" and
REM that would make the check more complicated.
for %%f in ("%ProgramFiles%\Vital Images\Management\webapps\management\WEB-INF\lib\log4j-core-*.jar") do (
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/net/JndiManager.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class | find "1 files" > nul && goto :stopServices
)
for %%f in ("%ProgramFiles%\Vital Images\Application\webapps\application\WEB-INF\lib\log4j-core-*.jar") do (
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/net/JndiManager.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class | find "1 files" > nul && goto :stopServices
)
for %%f in ("%ProgramFiles%\Vital Images\Data\webapps\data\WEB-INF\lib\log4j-core-*.jar") do (
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/net/JndiManager.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class | find "1 files" > nul && goto :stopServices
)
for %%f in ("%ProgramFiles%\Vital Images\Data\MintMetadataProcessor\lib\log4j-core-*.jar") do (
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/net/JndiManager.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class | find "1 files" > nul && goto :stopServices
)
for %%f in ("%ProgramFiles%\Vital Images\Part19ToPart10Converter\lib\log4j-core-*.jar") do (
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/net/JndiManager.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class | find "1 files" > nul && goto :stopServices
)
for %%f in ("%ProgramFiles%\Vital Images\DatabaseDeploymentTool\lib\log4j-core-*.jar") do (
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/net/JndiManager.class | find "1 files" > nul && goto :stopServices
    "%~dp0\7za.exe" l -tzip "%%f" org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class | find "1 files" > nul && goto :stopServices
)

if not x%LOG4J_FORMAT_MSG_NO_LOOKUPS%x == xtruex (
    echo INFO: Environment Variable 'LOG4J_FORMAT_MSG_NO_LOOKUPS' is either not present or is the incorrect value
    goto :stopServices
)

reg query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPManagementService\Parameters\Java" -v Options 2>nul | findstr "\-Dlog4j2.formatMsgNoLookups" >nul 2>&1
if errorlevel 1 (
    if exist "%ProgramFiles%\Vital Images\Management\bin\VspMgmtTomcat.exe" (
        goto :stopServices
    )
)
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPApplicationService\Parameters\Java" -v Options 2>nul | findstr "\-Dlog4j2.formatMsgNoLookups" >nul 2>&1
if errorlevel 1 (
    if exist "%ProgramFiles%\Vital Images\Application\bin\VspAppTomcat.exe" (
        goto :stopServices
    )
)
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPDataService\Parameters\Java" -v Options 2>nul | findstr "\-Dlog4j2.formatMsgNoLookups" >nul 2>&1
if errorlevel 1 (
    if exist "%ProgramFiles%\Vital Images\Data\bin\VspDataTomcat.exe" (
        goto :stopServices
    )
)

echo INFO: No actions required. Mitigation is already in place.
goto :exitSuccess

:stopServices
echo >con INFO: The script will now stop the VSP services as part of the process.
%WAIT% <con >con

echo INFO: Stopping VSP services
REM Stop in service dependency order.
for %%s in (Application Data Management) do (
    sc query Vsp%%sService >nul
    if errorlevel 1060 (
        echo INFO: Ignoring Vsp%%sService: not installed on this machine.
    ) else (
        sc query Vsp%%sService | find "STOPPED" > nul && echo INFO: Vsp%%sService already stopped.
        if errorlevel 1 (
            echo INFO: Stopping Vsp%%sService
            set _SVC_STOPPED=false
            net stop Vsp%%sService
            REM Re-check multiple times because the services may be slow to stop; but don't try forever, just 10 times.
            for /L %%n in (1, 1, 10) do (
                if !_SVC_STOPPED! == false (
                    sc query Vsp%%sService | find "STOPPED" > nul
                    if errorlevel 1 (
                        echo INFO: Vsp%%sService has not yet stopped on attempt %%n/10.  Will check again after a delay.
                        timeout 20 /nobreak
                    ) else (
                        REM We will continue to loop around up to 10 times after setting this to true, but we won't do
                        REM anything on subsequent passes.  This is needed because you can't use "goto" within a "for"
                        REM loop: it will stop the "for" loop iteration immediately.  In this case it would stop the
                        REM outermost iteration, and therefore anly stop one service.
                        set _SVC_STOPPED=true
                        echo INFO: Stopped Vsp%%sService
                    )
                )
            )
            if !_SVC_STOPPED! == false (
                echo ***************************************************************************
                echo ERROR: Failed to stop Vsp%%sService: Please stop it manually and try again.
                echo ***************************************************************************
                goto :exitFailure
            )
        )
    )
)

echo INFO: Updating HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPManagementService\Parameters\Java\Options to contain -Dlog4j2.formatMsgNoLookups if the registry key exists
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPManagementService\Parameters\Java" -v Options 2>nul | findstr "\-Dlog4j2.formatMsgNoLookups" >nul 2>&1
if errorlevel 1 (
    if exist "%ProgramFiles%\Vital Images\Management\bin\VspMgmtTomcat.exe" (
        "%ProgramFiles%\Vital Images\Management\bin\VspMgmtTomcat.exe" //US//VSPManagementService ++JvmOptions=-Dlog4j2.formatMsgNoLookups=true
    )
)
echo INFO: Updating HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPApplicationService\Parameters\Java\Options to contain -Dlog4j2.formatMsgNoLookups if the registry key exists
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPApplicationService\Parameters\Java" -v Options 2>nul | findstr "\-Dlog4j2.formatMsgNoLookups" >nul 2>&1
if errorlevel 1 (
    if exist "%ProgramFiles%\Vital Images\Application\bin\VspAppTomcat.exe" (
        "%ProgramFiles%\Vital Images\Application\bin\VspAppTomcat.exe" //US//VSPApplicationService ++JvmOptions=-Dlog4j2.formatMsgNoLookups=true
    )
)
echo INFO: Updating HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPDataService\Parameters\Java\Options to contain -Dlog4j2.formatMsgNoLookups if the registry key exists
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Apache Software Foundation\Procrun 2.0\VSPDataService\Parameters\Java" -v Options 2>nul | findstr "\-Dlog4j2.formatMsgNoLookups" >nul 2>&1
if errorlevel 1 (
    if exist "%ProgramFiles%\Vital Images\Data\bin\VspDataTomcat.exe" (
        "%ProgramFiles%\Vital Images\Data\bin\VspDataTomcat.exe" //US//VSPDataService ++JvmOptions=-Dlog4j2.formatMsgNoLookups=true
    )
)

echo INFO: Setting system environment variable LOG4J_FORMAT_MSG_NO_LOOKUPS to true
setx /M LOG4J_FORMAT_MSG_NO_LOOKUPS true

REM We delete both files at the same time here because otherwise the second delete may occasionally fail due to a
REM ".jar.tmp" file still being held open by 7za.exe.
for %%d in (Management\webapps\management\WEB-INF Application\webapps\application\WEB-INF Data\webapps\data\WEB-INF Data\MintMetadataProcessor Part19ToPart10Converter DatabaseDeploymentTool) do (
    echo INFO: Removing JndiLookup.class, JndiManager.class, and DataSourceConnectionSource.class from "%ProgramFiles%\Vital Images\%%d\lib\log4j-core-*.jar" if installed
    for %%f in ("%ProgramFiles%\Vital Images\%%d\lib\log4j-core-*.jar") do (
        if exist "%%f" (
            "%~dp0\7za.exe" d -tzip "%%f" org/apache/logging/log4j/core/lookup/JndiLookup.class^
                org/apache/logging/log4j/core/net/JndiManager.class^
                org/apache/logging/log4j/core/appender/db/jdbc/DataSourceConnectionSource.class
            if errorlevel 1 (
                echo ERROR: Failed to delete JNDI ".class" files from "%%f".  Possibly another process is accessing that file.
                goto :exitFailure
            )
        )
    )
)

echo INFO: Starting VSP services
REM Start in reverse service dependency order.
for %%s in (Management Data Application) do (
    sc query Vsp%%sService >nul
    if errorlevel 1060 (
        echo INFO: Ignoring Vsp%%sService: not installed on this machine.
    ) else (
        sc query Vsp%%sService | find "RUNNING" > nul && echo INFO: Vsp%%sService already running.
        if errorlevel 1 (
            echo INFO: Starting Vsp%%sService
            net start Vsp%%sService
            sc query Vsp%%sService | find "RUNNING" > nul
            if errorlevel 1 (
                echo *****************************************************************************************
                echo ERROR: Failed to start Vsp%%sService: Please start all non-running VSP services manually.
                echo *****************************************************************************************
                rem If any service fails to start, don't try the rest as there are dependencies between them.
                goto :exitFailure
            )
        )
    )
)

:exitSuccess
echo >con INFO: Script completed successfully.
%WAIT% <con >con
exit /b 0

:exitFailure
echo >con ERROR: One or more errors occurred.  Please see script output for details.
%WAIT% <con >con
exit /b 1
